# -*- coding: UTF-8 -*-
# 作者：幻灰龙
# 标题：Python 汇编
# 描述：输出 Python 代码的汇编，找到含有"Hello,world!"的指令

import dis

if __name__ == "__main__":
    code_str = """
print("Hello,world!")
print("Hello,world!")
"""
    code_obj = compile(code_str, '<string>', 'exec')

    ins = dis.get_instructions(code_obj)
    hello_world_il_count = 0
    for il in ins:
        if il.argval == 'Hello,world!':
            print(il)
            hello_world_il_count += 1
    assert hello_world_il_count == 2
